/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.xml;

import org.jbpm.gd.jpdl.xml.ControllerDomAdapter;
import org.w3c.dom.NodeList;

/**
 * Dom Adaptor of a controller. Jbpm's implementation had to be overwridden becuase the
 * gettextmethod didnt check if the node's value was null when returning the text content.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPControllerDomAdapter extends ControllerDomAdapter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#getTextContent()
	 */
	@Override
	protected String getTextContent() {
		StringBuffer buffer = new StringBuffer();
		NodeList list = getNode().getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			String nodeValue = list.item(i).getNodeValue();
			if (nodeValue != null)
				buffer.append(nodeValue);
		}
		return buffer.toString().trim();
	}
}
