/*
 * Created on Aug 8, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.xml;

import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.xml.ScriptDomAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * The Script Dom Adapter
 * 
 * @author Vijay Silva
 */
public class WPScriptDomAdapter extends ScriptDomAdapter
{
	private static final String PADDING = "\t";

	private static final String INTER_CHILD_SPACING = "\n";

	/**
	 * @see org.jbpm.gd.common.xml.XmlAdapter#notifyChanged(org.eclipse.wst.sse.core.internal.provisional.INodeNotifier,
	 *      int, java.lang.Object, java.lang.Object, java.lang.Object, int)
	 */
	@SuppressWarnings("restriction")
	@Override
	public void notifyChanged(org.eclipse.wst.sse.core.internal.provisional.INodeNotifier notifier,
			int eventType, Object changedFeature, Object oldValue, Object newValue, int pos)
	{
		if (org.eclipse.wst.sse.core.internal.provisional.INodeNotifier.ADD == eventType)
		{
			handleDomAdd(newValue);
		}
		else if (org.eclipse.wst.sse.core.internal.provisional.INodeNotifier.REMOVE == eventType)
		{
			handleDomRemove(oldValue);
		}
		else if (changedFeature != null)
		{
			doModelUpdate(((Node) changedFeature).getNodeName(), (String) newValue);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ScriptDomAdapter#doModelUpdate(java.lang.String, java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue)
	{
		Script script = (Script) this.getSemanticElement();

		if ("#cdata-section".equals(name))
		{
			String content = this.getTextContent();
			script.setScript(content);
		}
		else if ("#text".equals(name))
		{
			String content = this.getTextContent();
			replaceScriptContent(content);
			script.setScript(content);
		}
		else
		{
			super.doModelUpdate(name, newValue);
		}
	}

	/**
	 * Set the Text Content for the Node managed by the Adapter
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#setTextContent(java.lang.String)
	 */
	@Override
	protected void setTextContent(String content)
	{
		String oldContent = this.getTextContent();
		if (content == null)
			content = "";

		if (content.equals(oldContent))
			return;

		replaceScriptContent(content);
	}

	/*
	 * Removes all the text content of the script element and creates a single CData section with
	 * all the content.
	 */
	private void replaceScriptContent(String content)
	{
		removeTextChildren();
		replaceTextChild(content);
	}

	/*
	 * Removes all child text and cdata sections
	 */
	private void removeTextChildren()
	{
		NodeList list = getNode().getChildNodes();
		for (int i = 0; i < list.getLength(); i++)
		{
			short nodeType = list.item(i).getNodeType();
			if (nodeType == Node.TEXT_NODE || nodeType == Node.CDATA_SECTION_NODE)
			{
				getNode().removeChild(list.item(i--));
			}
		}
	}

	/*
	 * Creates a new CData Section containing the
	 */
	private void replaceTextChild(String content)
	{
		Node node = this.getNode();
		Document document = node.getOwnerDocument();

		if (content != null && !content.equals(""))
		{
			int level = this.getNodeLevel();
			node.appendChild(document.createTextNode(this.getElementSpacingString(level)));
			node.appendChild(document.createCDATASection(content));
			node.appendChild(document.createTextNode(this.getElementSpacingString(level - 1)));
		}
	}

	/*
	 * Get the 'level' of the node indicating the number of ancestors it has in the dom tree.
	 */
	private int getNodeLevel()
	{
		int result = 0;
		Node node = this.getNode();
		Document document = node.getOwnerDocument();
		while (node != null && node != document)
		{
			result++;
			node = node.getParentNode();
		}

		return result;
	}

	private String getElementSpacingString(int level)
	{
		StringBuilder result = new StringBuilder();
		result.append(INTER_CHILD_SPACING);
		for (int i = 0; i < level; i++)
		{
			result.append(PADDING);
		}

		return result.toString();
	}
}
