/**
 * 
 */
package com.tandbergtv.watchpoint.studio.util;

/**
 * @author DReddy
 * 
 */
public class ValidationUtil {

	/**
	 * Gets the operands in an expression
	 * 
	 * @param expr
	 * @return Operands
	 */
	public static String[] getOperands(String expr) {
		String[] tempOperands = new String[10];
		String[] operands = null;
		int ol = 0;
		int sLength = expr.length();
		int i = 0;

		while (i < sLength) {
			if (expr.charAt(i) != '(') {
				tempOperands[ol] = getNextValueOperand(expr.substring(i));
				i = i + tempOperands[ol].length() + 1;
				ol++;
			} else {
				tempOperands[ol] = getNextExprOperand(expr.substring(i));
				i = i + tempOperands[ol].length() + 1;
				ol++;
			}
		}
		operands = new String[ol];
		for (int j = 0; j < ol; j++) {
			operands[j] = tempOperands[j];
		}
		return operands;
	}

	/**
	 * Gets the operator from an expression
	 * 
	 * @param expr
	 * @return The operator character
	 */
	public static char getOperator(String expr) {
		int sLength = expr.length();
		int i = 0;
		char operator = ' ';
		while (i < sLength) {
			if (expr.charAt(i) != '(') {
				int index = getNextValueOperator(expr.substring(i));
				if (index < sLength)
					operator = expr.charAt(index);
				break;

			} else {
				int index = getNextExprOperator(expr.substring(i));
				operator = expr.charAt(index);
				break;
			}

		}
		return operator;
	}

	/*
	 * Gets the operand from an expression
	 */
	private static String getNextValueOperand(String expr) {
		int sLength = expr.length();
		for (int i = 0; i < sLength; i++) {
			char c = expr.charAt(i);
			// Checks whether the character is alphanumeric and ':' to support
			// Duration constants
			if (((c > 'z' || c < 'a') && (c > 'Z' || c < 'A'))
					&& (c > '9' || c < '0') && (c != ':'))
				return expr.substring(0, i);
		}
		return expr;
	}

	/*
	 * Gets the next Expression in the expression
	 */
	private static String getNextExprOperand(String expr) {

		int lp = 0;
		int rp = 0;
		int i = 0;
		while (lp != rp || lp == 0) {
			char c = expr.charAt(i);
			if (c == '(') {
				lp++;
			} else if (c == ')') {
				rp++;
			}
			i++;
		}
		return expr.substring(0, i);
	}

	/*
	 * Gets the next operator
	 */
	private static int getNextValueOperator(String expr) {
		int sLength = expr.length();
		for (int i = 1; i < sLength; i++) {
			char c = expr.charAt(i);
			if (((c > 'z' || c < 'a') && (c > 'Z' || c < 'A'))
					&& (c > '9' || c < '0') && (c != ':'))

				return i;
		}
		return sLength;
	}

	/*
	 * Gets the next operator from expression
	 */
	private static int getNextExprOperator(String expr) {

		int lp = 0;
		int rp = 0;
		int i = 0;
		while (lp != rp || lp == 0) {
			char c = expr.charAt(i);
			if (c == '(') {
				lp++;
			} else if (c == ')') {
				rp++;
			}

			i++;
		}

		return i;
	}
}
