/*
 * Created on Jul 10, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

import java.util.List;

import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * The Validation Service is the exposed facade that performs validation on the top level entities
 * that require validation in the user interface.
 * 
 * @author Vijay Silva
 */
public interface IValidationService {

    List<ValidationMessage> validateTemplate(WorkflowTemplate template);

	List<ValidationMessage> validateNodeDefinition(NodeDefinition nodeDefinition);
	
	List<ValidationMessage> validateActionVariableName(GenericElement element);

    List<ValidationMessage> validateActionVariableValue(AutomaticTaskNode node, GenericElement element);

	List<ValidationMessage> validateTemplate(WorkflowTemplateDTO template);

	List<ValidationMessage> validateResourceType(ResourceType resourceType);

	List<ValidationMessage> validateResourceGroup(ResourceGroup group);

	List<ValidationMessage> validateMessage(Message message);

    List<ValidationMessage> validateCondition(NodeElement source, Transition transition, WorkflowTemplate container);

    List<ValidationMessage> validateCondition(NodeElement source, Transition transition, NodeDefinition container);

    List<ValidationMessage> validateLoopNodeExpression(LoopNode loopNode, WorkflowTemplate container);

    List<ValidationMessage> validateLoopNodeExpression(LoopNode loopNode, NodeDefinition container);

    List<ValidationMessage> validateDueDate(IDueDateElement dueDateElement, WorkflowTemplate template);

    List<ValidationMessage> validateDueDate(IDueDateElement dueDateElement, NodeDefinition nodeDefinition);

    List<ValidationMessage> validateDecisionExpression(Decision decision, WorkflowTemplate container);

    List<ValidationMessage> validateDecisionExpression(Decision decision, NodeDefinition container);
}
