package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.assignnode;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.editor.expression.ExpressionUtil;
import com.tandbergtv.watchpoint.studio.ui.model.AssignNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.rules.expression.VariableExpressionValidator;

public class AssignNodeExpressionValidRule extends ValidationRule<AssignNode> {

    @Override
    public List<ValidationMessage> validateRule(AssignNode target) {
        List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        if (target.getTasks() == null || target.getTasks().length == 0 || target.getTasks()[0] == null
                || target.getTasks()[0].getController() == null) {
            return messages;
        }

        WorkflowTemplate template = Utility.getTemplate(target);
        List<? extends Variable> startStateVariables = Utility.getVariables(template);
        String templateLocation = template.getLocation();
        VariableExpressionValidator variableExpressionValidator = null;
        for (Variable variable : target.getTasks()[0].getController().getVariables()) {

            if (variableExpressionValidator == null) {
                variableExpressionValidator = new VariableExpressionValidator();
                variableExpressionValidator.setProject(ResourcesPlugin.getWorkspace().getRoot()
                        .getFile(new Path(templateLocation)).getProject());
                variableExpressionValidator.setContextVariables(ExpressionUtil
                        .toJavaVariableStr(startStateVariables));
            }

            WPVariable v = (WPVariable) variable;
            DataType t = DataType.STRING;

            if (v.getType() != null) {
                t = DataType.valueOf(v.getType());
            }

            variableExpressionValidator.setReturnType(t);
            variableExpressionValidator.validateExpression(v.getValue());

            if (variableExpressionValidator.hasErrors()) {
                List<String> parameters = new ArrayList<String>();
                parameters.add(v.getMappedName());
                parameters.add(v.getValue());
                ValidationMessageAdder.getInstance().addValidationMessage(messages, target,
                        ValidationMessageCode.NODE_VARIABLE_MAPPING_INVALID_SCRIPT, parameters);
            }
        }

        return messages;
    }
}