package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.common.model.SemanticElementFactory;

import com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants;
import com.tandbergtv.watchpoint.studio.ui.model.WPAbstractNode;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;


/**
 *  Class that overrides the one inside the ui.jar file. 
 */
public class StartState extends WPAbstractNode {
	
	private Task task;
	
	public StartState(List<WPVariable> variables) {
	    if (getFactory() == null) {
	        setFactory(new SemanticElementFactory(Utility.TEMPLATE_EDITOR_ID));
	    }
	    if (task == null) {
	       task = (Task) getFactory().createById(SemanticElementConstants.TASK_SEID); 
	    }
	    if (task.getController() == null) {
	        task.setController((Controller) getFactory().createById(SemanticElementConstants.CONTROLLER_SEID));
	    }
	    for (WPVariable variable : variables) {
	        task.getController().addVariable(variable);
	    }
    }
	
	public StartState() {
	}

    public void setTask(Task newTask) {
		Task oldTask = task;
		task = newTask;
		firePropertyChange("task", oldTask, newTask);
	}
	
	public Task getTask() {
		return task;
	}
	
	public boolean isPossibleChildOf(NodeElementContainer nodeElementContainer) {
		return nodeElementContainer instanceof ProcessDefinition && ((ProcessDefinition)nodeElementContainer).getStartState() == null;
	}
	
	public void initializeName(ProcessDefinition processDefinition) {
		setName(getNamePrefix());
	}

    public List<WPVariable> getVariables() {
        List<WPVariable> variables = new ArrayList<WPVariable>();
        if (task == null || task.getController() == null || task.getController().getVariables() == null) {
            return variables;
        }

        for (Variable variable : task.getController().getVariables()) {
            variables.add((WPVariable) variable);
        }
        return variables;
    }

    public List<WPVariable> getValidVariables() {
        List<WPVariable> allVariables = getVariables();
        List<WPVariable> validVariables = new ArrayList<WPVariable>(); 
        for (WPVariable variable : allVariables) {
            if (variable.isNameValid()) {
                validVariables.add(variable);
            }
        }
        return validVariables;
    }

    public WPVariable getVariable(String name) {
        for (WPVariable variable : getValidVariables()) {
            if (variable.getName().equals(name)) {
                return variable;
            }
        }
        return null;
    }

    public WPVariable addEmptyVariable(String variableName) {
        Task task = getNonEmptyTask();

        WPVariable variable = (WPVariable) getFactory().createById(SemanticElementConstants.VARIABLE_SEID);
        variable.setMappedName(variableName); 
        variable.setName(variableName);
        variable.setType(DataType.STRING.name());
        variable.setValue("");
        variable.setAccess("read,write");
        task.getController().addVariable(variable);
        return variable;
    }

    public void removeVariable(WPVariable variable) {
        getNonEmptyTask().getController().removeVariable(variable);
    }
    
    private Task getNonEmptyTask() {
        Task task = getTask();
        if (task == null) {
            task = (Task) getFactory().createById(SemanticElementConstants.TASK_SEID);
            setTask(task);
        }

        Controller controller = task.getController();
        if (controller == null) {
            controller = (Controller) getFactory().createById(SemanticElementConstants.CONTROLLER_SEID);
            task.setController(controller);
        }
        
        return task;
    }
}