/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.exe;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.parser.RuntimeTemplateParser;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.EventDispatcher;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessEventListener
implements IColleague {
    private static final Logger logger = Logger.getLogger(ProcessEventListener.class);
    private EventDispatcher eventDispatcher;

    public ProcessEventListener(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public String getColleagueName() {
        return "debugger-events";
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof WorkflowProcessEvent)) {
            return;
        }
        WorkflowProcessEvent e = (WorkflowProcessEvent)event;
        logger.debug((Object)(e.getToken() + " event " + e.getType()));
        switch (e.getType()) {
            case PAUSED: {
                this.paused(e.getProcess());
                break;
            }
            case RESUMED: {
                this.resumed(e.getProcess());
                break;
            }
            case STARTED: {
                this.started(e.getProcess());
                break;
            }
            case CREATED: {
                this.created(e.getProcess());
            }
        }
    }

    private void created(WorkflowProcess process) {
        this.eventDispatcher.started();
    }

    private void started(WorkflowProcess process) {
        if (!this.hasParent(process)) {
            logger.debug((Object)"started event received, but process has no parents");
            return;
        }
        WorkflowProcess parent = process.getSuperProcessToken().getProcessInstance();
        String dir = (String)parent.getContextInstance().getTransientVariable("__dir");
        process.getRuntimeActions().clear();
        process.getContextInstance().setTransientVariable("__dir", (Object)dir);
        Map<String, NodeSimulationConfig> map = RuntimeTemplateParser.parse(new File(dir), (ProcessDefinition)process.getProcessDefinition());
        process.getContextInstance().setTransientVariable("_simulationconfig", map);
    }

    private void paused(WorkflowProcess process) {
        if (this.hasParent(process)) {
            logger.debug((Object)"paused event received, but it has parents");
            return;
        }
        this.eventDispatcher.suspended(process.getRootToken().getCurrentNode().getName());
    }

    private void resumed(WorkflowProcess process) {
        if (this.hasParent(process)) {
            logger.debug((Object)"resumed event received, but it has parents");
            return;
        }
        this.eventDispatcher.resumed();
    }

    private boolean hasParent(WorkflowProcess process) {
        return process.getSuperProcessToken() != null;
    }
}

