/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.ProcessState2;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.AutomaticTaskNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.DecisionNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.LoopNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.MailNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.MessageNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.StartStateNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.SubProcessNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.SuperStateNodeSimulator;
import com.tandbergtv.workflow.core.MailNode;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public class NodeSimulatorFactory {
    Map<String, NodeSimulationConfig> simulationConfigMap;

    public NodeSimulatorFactory(Map<String, NodeSimulationConfig> simulationConfigMap) {
        this.simulationConfigMap = simulationConfigMap;
    }

    public NodeSimulator getSimulatorFor(Node node) {
        NodeSimulator simulator = null;
        if (this.getSuperState(node) instanceof NodeGroup) {
            simulator = new SuperStateNodeSimulator();
            node = this.getSuperState(node);
        } else if (node instanceof NodeGroup) {
            simulator = new SuperStateNodeSimulator();
        } else if (node instanceof Decision) {
            simulator = new DecisionNodeSimulator();
        } else if (node instanceof Loop2) {
            simulator = new LoopNodeSimulator();
        } else if (node instanceof MailNode) {
            simulator = new MailNodeSimulator();
        } else if (node instanceof ProcessState2) {
            simulator = new SubProcessNodeSimulator();
        } else if (node instanceof ManualTaskNode) {
            simulator = new MessageNodeSimulator();
        } else if (node instanceof TaskNode) {
            Task task = node.getProcessDefinition().getTaskMgmtDefinition().getTask(node.getName());
            simulator = task == null ? new AutomaticTaskNodeSimulator() : new MessageNodeSimulator();
        } else if (node instanceof StartState) {
            simulator = new StartStateNodeSimulator();
        }
        if (simulator != null) {
            simulator.setNode(node);
            NodeSimulationConfig config = this.simulationConfigMap.get(node.getName());
            if (config == null) {
                config = new NodeSimulationConfig();
            }
            simulator.setSimulationConfig(config);
        }
        return simulator;
    }

    protected Node getSuperState(Node node) {
        Node parent = node;
        while (parent.getSuperState() instanceof SuperState) {
            if (!((parent = parent.getSuperState()) instanceof NodeGroup)) continue;
            return parent;
        }
        return node;
    }
}

