/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.template;

import com.tandbergtv.watchpoint.studio.debugger.runtime.Services;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.ManualTaskHandler;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.NodeEnterHandler;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.NodeLeaveHandler;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.ProcessEndHandler;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.SimulationDataHandler;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ExtendedJpdlXmlReader;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.StartState;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class JPDLParser
extends ExtendedJpdlXmlReader {
    private File dir;
    private static final long serialVersionUID = -8644316196789750523L;
    private static final Logger logger = Logger.getLogger(JPDLParser.class);

    public JPDLParser(String name) throws FileNotFoundException {
        super((InputStream)new FileInputStream(name));
        this.dir = new File(name).getParentFile().getParentFile();
    }

    public ProcessDefinition readProcessDefinition() {
        super.readProcessDefinition();
        Event event = new Event((GraphElement)this.processDefinition, "process-end");
        event.addAction(new Action(new Delegation(ProcessEndHandler.class.getName())));
        this.processDefinition.addEvent(event);
        this.save(this.processDefinition);
        return this.processDefinition;
    }

    protected void parseProtectionKeys(Element root) {
    }

    public Map<String, String> getPredefinedActions() {
        return new HashMap<String, String>();
    }

    public void readNodes(Element element, NodeCollection nodeCollection) {
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            Class type = NodeTypes.getNodeType((String)name);
            if (type == null) continue;
            Node node = null;
            try {
                node = (Node)type.newInstance();
            }
            catch (Exception e1) {
                this.addError("Couldn't instantiate node " + name + " of type " + type.getName(), e1);
                continue;
            }
            node.setProcessDefinition(this.processDefinition);
            if (node instanceof StartState && this.processDefinition.getStartState() != null) {
                this.addError("At most one start-state allowed in a process");
                continue;
            }
            this.readNode(e, node, nodeCollection);
            if (node instanceof ProcessState) {
                File f = new File(this.dir, e.element("sub-process").attributeValue("name"));
                this.parse(new File(f, "processdefinition.xml").getAbsolutePath());
            } else {
                boolean cfr_ignored_0 = node instanceof Decision;
            }
            node.read(e, (JpdlXmlReader)this);
        }
    }

    protected void addAction(GraphElement graphElement, String eventType, Action action) {
        if ("transition".equals(eventType)) {
            return;
        }
        if ("node-leave".equals(eventType) || "superstate-leave".equals(eventType)) {
            action = new Action(new Delegation(NodeLeaveHandler.class.getName()));
        } else if ("node-enter".equals(eventType) || "superstate-enter".equals(eventType)) {
            action = new Action(new Delegation(NodeEnterHandler.class.getName()));
        }
        super.addAction(graphElement, eventType, action);
    }

    public Action readSingleAction(Element e) {
        Action action = super.readSingleAction(e);
        if (action != null && action.getActionDelegation() != null) {
            Delegation d = action.getActionDelegation();
            String className = d.getClassName();
            if (className.endsWith("MessageEmitter") || className.endsWith("MessageReceiver")) {
                d.setClassName(SimulationDataHandler.class.getName());
                d.setConfiguration(null);
            } else if (className.endsWith("TaskNotificationHandler")) {
                d.setClassName(ManualTaskHandler.class.getName());
                d.setConfiguration(null);
            } else {
                logger.info((Object)className);
            }
        }
        return action;
    }

    protected void readExceptionHandler(Element element, GraphElement graphElement) {
        super.readExceptionHandler(element, graphElement);
    }

    protected void parse(String name) {
        try {
            new JPDLParser(name).readProcessDefinition();
        }
        catch (FileNotFoundException e) {
            throw new TemplateReaderException(name, (Throwable)e);
        }
    }

    protected void save(ProcessDefinition template) {
        try {
            Services.getService(ITemplateLoaderService.class).update((WorkflowTemplate)template);
        }
        catch (DriverException e) {
            throw new TemplateReaderException(":(", (Throwable)e);
        }
    }
}

