/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class SocketListener
implements Runnable {
    protected ServerSocket serverSocket;

    public SocketListener(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public void run() {
        this.waitForConnection();
    }

    protected void waitForConnection() {
        try {
            Socket clientSocket = this.serverSocket.accept();
            this.processClientSocket(clientSocket);
            clientSocket.close();
        }
        catch (IOException e) {
            this.treatException(e);
        }
    }

    protected void treatException(Exception e) {
        System.out.println(new StringBuilder().append("Accept failed: ").append(this.serverSocket.getLocalPort()).append(" due to ").append(e.getMessage()));
        System.exit(-1);
    }

    protected abstract void processClientSocket(Socket var1) throws IOException;
}

