/*
 * Created on Jun 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI;
import com.tandbergtv.watchpoint.studio.dto.Message;

/**
 * The JPA Data Access Implementation for the Message entity.
 * 
 * @author Vijay Silva
 */
public class MessagePDAO extends PersistenceDAO<Message, Long> implements MessageDAI
{
	/**
	 * Constructor
	 * 
	 * @param persistenceContext
	 *            The Persistence Context to use for data operations.
	 */
	public MessagePDAO(JPAPersistenceContext persistenceContext)
	{
		super(Message.class, persistenceContext);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI#findUnusedByResourceType(long)
	 */
	@SuppressWarnings("unchecked")
	public List<Message> findUnusedByResourceType(long resourceTypeId)
	{
		String queryName = "Message.UnusedByResourceType";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("resourceTypeId", resourceTypeId);
		return query.getResultList();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI#findUnusedByResourceType(long, long)
	 */
	@SuppressWarnings("unchecked")
	public List<Message> findUnusedByResourceType(long resourceTypeId, long nodeDefinitionId)
	{
		String queryName = "Message.UnusedByResourceTypeAndNodeDefinition";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("resourceTypeId", resourceTypeId);
		query.setParameter("nodeDefinitionId", nodeDefinitionId);
		return query.getResultList();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI#findByUID(java.lang.String)
	 */
	public Message findByUID(String messageUID)
	{
		String queryName = "Message.ByUID";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("messageUID", messageUID);
		Message message = null;
		try {
			message = (Message) query.getSingleResult();
		} catch (NoResultException e) {
			// No message found - return null
		}
		return message;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI#getCountByUID(String)
	 */
	public int getCountByUID(String messageUID)
	{
		String queryName = "Message.CountByUID";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("messageUID", messageUID);
		Long count = (Long) query.getSingleResult();
		return count.intValue();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI#getCountByResourceTypeAndName(long,
	 *      java.lang.String)
	 */
	public int getCountByResourceTypeAndName(long resourceTypeId, String messageName)
	{
		String queryName = "Message.CountByResourceTypeIdAndName";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("resourceTypeId", resourceTypeId);
		query.setParameter("messageName", messageName);
		Long count = (Long) query.getSingleResult();
		return count.intValue();
	}
}
