/*
 * Created on Jun 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

/**
 * The WPCL Message entity
 * 
 * @author Vijay Silva
 */
public class Message implements IWatchPointDTO, IPersistable
{
	private static final long serialVersionUID = -1636933676350231396L;

	private long id = DEFAULT_ID;

	private String uid;

	private String name;

	private String description;

	private boolean incoming;

	private String protocol;

	private ResourceType resourceType;

	private boolean uidGenerationRequired = false;

	/**
	 * Default Constructor
	 */
	public Message()
	{
		super();
	}

	/**
	 * Constructor
	 * 
	 * @param id
	 *            Id of the message
	 * @param name
	 *            Name of the message
	 */
	public Message(long id, String name)
	{
		super();
		this.id = id;
		this.name = name;
	}

	/**
	 * Gets the Message Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * @return the id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * @return the description
	 */
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @return the isIncoming
	 */
	public boolean isIncoming()
	{
		return this.incoming;
	}

	/**
	 * @param isIncoming
	 *            the isIncoming to set
	 */
	public void setIncoming(boolean isIncoming)
	{
		this.incoming = isIncoming;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the protocol
	 */
	public String getProtocol()
	{
		return this.protocol;
	}

	/**
	 * @param protocol
	 *            the protocol to set
	 */
	public void setProtocol(String protocol)
	{
		this.protocol = protocol;
	}

	/**
	 * @return the uid
	 */
	public String getUid()
	{
		return this.uid;
	}

	/**
	 * @param uid
	 *            the uid to set
	 */
	public void setUid(String uid)
	{
		this.uid = uid;
	}

	/**
	 * Get the flag indicating that the UID generation is required for this message
	 * 
	 * @return true if UID generation is required for this message, false otherwise
	 */
	public boolean isUIDGenerationRequired()
	{
		return this.uidGenerationRequired;
	}

	/**
	 * Set the flag indicating that the UID generation is required for this message
	 * 
	 * @param generateUidRequired
	 *            the generateUidRequired flag
	 */
	public void setUIDGenerationRequired(boolean generateUidRequired)
	{
		this.uidGenerationRequired = generateUidRequired;
	}

	/**
	 * @return the resourceType
	 */
	public ResourceType getResourceType()
	{
		return this.resourceType;
	}

	/**
	 * @param resourceType
	 *            the resourceType to set
	 */
	public void setResourceType(ResourceType resourceType)
	{
		this.resourceType = resourceType;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 9 - 347;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof Message))
			return false;

		Message message = (Message) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && message.id == DEFAULT_ID)
			return super.equals(message);

		return (this.id == message.id);
	}

	/**
	 * Clones the Message
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Message clone()
	{
		Message clone = null;

		try
		{
			// Do not clone the parent Resource Type
			clone = (Message) super.clone();
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return "Message [" + uid + "] " + name;
	}
}
