/**
 * ResourceGroupDAO.java
 * Created Feb 17, 2010
 */
package com.tandbergtv.watchpoint.studio.external.fs.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.jpf.JPFContext;
import com.tandbergtv.watchpoint.studio.external.jpf.JPFPluginManager;
import com.tandbergtv.watchpoint.studio.external.jpf.model.ResourceGroupDescriptor;

/**
 * @author Sahil Verma
 */
public class ResourceGroupDAO implements ResourceGroupDAI {
	
	private IPersistenceContext context;

	/**
	 * @param context
	 */
	public ResourceGroupDAO(JPFContext context) {
		super();
		this.context = context;
	}

	/**
	 * {@inheritDoc}
	 */
	public List<ResourceGroup> findAll() {
		List<ResourceGroup> groups = new ArrayList<ResourceGroup>();
		JPFPluginManager loader = JPFContext.class.cast(context).getPluginManager();
		
		for (ResourceGroupDescriptor plugin : loader.getResourceGroupDescriptors()) {
			ResourceGroup group = createResourceGroup(plugin);
			
			if (group != null)
				groups.add(group);
		}
		
		return groups;
	}

	/**
	 * {@inheritDoc}
	 */
	public IPersistenceContext getPersistenceContext() {
		return this.context;
	}
	
	protected ResourceGroup createResourceGroup(ResourceGroupDescriptor plugin) {
		ResourceGroup group = new ResourceGroup();
		
		group.setSystemId(plugin.getSystemId());
		group.setName(plugin.getName());
		group.setDescription(plugin.getDescription());
		group.setProtectionKey(new ProtectionKey(plugin.getAccessLevel()));
		group.setAllocationStrategyClassName(plugin.getAllocationStrategyClass());
		group.setFunctionalType(plugin.getFunctionalType());
		group.setInternallyAcquired(plugin.getIsInternallyAcquired());
		group.setVersion(plugin.getVersion());
		group.setPath(plugin.getPath());
		
		group.setImageFileName(plugin.getImagePath());;

		return group;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<ResourceGroup> findByName(String name) {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<ResourceGroup> findByNames(Collection<String> names) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<ResourceGroup> findByResourceTypeSystemId(String systemId) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ProtectionKey findProtectionKeyByName(String name) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<String> getAllFunctionalTypesForResourceType(String resourceTypeSystemId) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getCountByResourceType(String systemId) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isNameExists(String name) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ResourceGroup create(ResourceGroup entity) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void delete(Long key) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ResourceGroup find(Long key) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ResourceGroup update(ResourceGroup entity) {
		throw new UnsupportedOperationException();
	}

	@Override
	public ResourceGroup findByPath(String path) {
		throw new UnsupportedOperationException();
	}

	@Override
	public List<ResourceGroup> findByProject(String project) {
		throw new UnsupportedOperationException();
	}

	@Override
	public List<ResourceGroup> findByTemplateUsage(String templatePath) {
		throw new UnsupportedOperationException();	
	}
}
