/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.actionconfig;

/**
 * A class to hold information regarding variables for out-of-the-box action handlers.
 * 
 * @author Imran Naqvi
 */
public class ActionVariableConfiguration {

	private String name;

	private boolean required = false;

	private String validationRuleClassName = null;

	/**
	 * @param name
	 *            The Variable Name
	 * @param required
	 *            Flag indicating that the value is required (cannot be blank)
	 * @param validationRule
	 *            The name of the ActionVariableValueRule class implementation to use for validation
	 *            on the variable values.
	 */
	public ActionVariableConfiguration(String name, boolean required, String validationRule) {
		this.name = name;
		this.required = required;
		this.validationRuleClassName = validationRule;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the required
	 */
	public boolean isRequired() {
		return required;
	}

	/**
	 * Get the class name of the Validator.
	 * 
	 * @return the validatorClassName
	 */
	public String getValidationRuleClassName() {
		return this.validationRuleClassName;
	}
}
