/**
 * CompositeCommand.java
 * Created Apr 17, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.command;

import java.util.ArrayList;
import java.util.List;

/**
 * A composite command can execute multiple sub-commands
 * 
 * @author Sahil Verma
 */
public class CompositeCommand extends AbstractCommand {

	private List<ICommand> commands;
	
	/**
	 * @param name
	 * @param description
	 */
	public CompositeCommand(String name, String description) {
		super(name, description);
		this.commands = new ArrayList<ICommand>();
	}

	/**
	 * @return the commands
	 */
	protected List<ICommand> getCommands() {
		return commands;
	}

	/**
	 * @param command
	 */
	public void addCommand(ICommand command) {
		this.commands.add(command);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		for (ICommand command : commands)
			command.execute();
	}
}
