/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IPersistableElement;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * A file editor input that doesn't persist its state when the editor is closed.
 * 
 * @author Imran Naqvi
 *
 */
public class NonPersistableFileEditorInput extends WPFileEditorInput {

	public NonPersistableFileEditorInput(IFile file, IWatchPointDTO watchPointDTO) {
		super(file, watchPointDTO);
	}
	
	/**
	 * @see org.eclipse.ui.part.FileEditorInput#getPersistable()
	 */
	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	/**
	 * @see org.eclipse.ui.part.FileEditorInput#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof NonPersistableFileEditorInput))
			return false;

		return super.equals(obj);
	}

}
