package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TemplateEditorPasteCommandHandler extends AbstractHandler {

	@Override
	public void dispose() {

	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		// Get selection
		WatchPointTemplateEditor activeEditor = getActiveTemplateEditor(event);
		if(activeEditor != null){
			// Create command class
			TemplateEditorPasteCommand command = new TemplateEditorPasteCommand(  );
			command.setTemplateEditor(activeEditor);
			command.execute();
		} else {
			System.out.println("Not a template editor.");
		}
		
		return null;
	}
	
	private WatchPointTemplateEditor getActiveTemplateEditor(ExecutionEvent event){
		IEditorPart selection = HandlerUtil.getActiveEditor(event);
		if(selection instanceof WatchPointTemplateEditor){
			return (WatchPointTemplateEditor) selection;
		} else {
			return null;
		}
	}
	
	@Override
	public void setEnabled(Object evaluationContext) {
		super.setEnabled(evaluationContext);
	}
	
	


}
