package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.Editor;
import org.jbpm.gd.common.editor.GraphPage;

public class WatchPointTemplateGraphPage extends GraphPage {

    public WatchPointTemplateGraphPage(Editor editor) {
        super(editor);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    	saveImage();
    }

    /**
     * Save the template as JPEG image.
     */
    public void saveImage() {
        saveImage(SWT.IMAGE_JPEG);
    }

    /**
     * Save the template to image.
     * 
     * @param type
     *            {@link SWT#IMAGE_JPEG}, {@link SWT#IMAGE_PNG}, {@link SWT#IMAGE_BMP}
     */
    public void saveImage(int type) {
        SWTGraphics g = null;
        GC gc = null;
        Image image = null;

        LayerManager lm = (LayerManager) getDesignerModelViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer("Printable Layers");
        try {
            Rectangle r = figure.getBounds();
            getEditor().getRootContainer().setDimension(new Dimension(r.width, r.height));
            image = new Image(Display.getDefault(), r.width, r.height);
            gc = new GC(image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint(g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[] { image.getImageData() };
            imageLoader.save(getImageSavePath().toOSString(), type);
            refreshProcessFolder();
        } finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    /**
     * Get the path of the image file.
     * 
     * @return
     */
    public IPath getImageSavePath() {
        IFile file = ((FileEditorInput) getEditorInput()).getFile();
        String name = file.getName();
        if (name.startsWith(".gpd.") && name.length() > 7) {
            name = name.substring(5, name.length() - 3) + "jpg";
        } else {
            name = this.getEditor().getDefaultImageFileName();
        }
        return file.getRawLocation().removeLastSegments(1).append(name);
    }

    private void refreshProcessFolder() {
        try {
            IFile file = ((FileEditorInput) getEditorInput()).getFile();
            file.getParent().refreshLocal(1, null);
        } catch (CoreException e) {
            e.printStackTrace();
        }
    }
}
