/*
 * Created on Aug 8, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.model;

/**
 * Constants used for the Semantic Elements.
 * 
 * @author Vijay Silva
 */
public final class SemanticElementConstants
{
	private SemanticElementConstants()
	{
	}

	/**
	 * The Semantic Element ID for the Workflow Template Semantic Element.
	 */
	public static final String TEMPLATE_SEID = "org.jbpm.gd.jpdl.processDefinition";

	/**
	 * The Semantic Element ID for the Node Definition Semantic Element.
	 */
	public static final String NODE_DEFN_SEID = "com.tandbergtv.watchpoint.studio.nodeDefinition";

	/**
	 * The Semantic element ID for the Script Semantic Element
	 */
	public static final String SCRIPT_SEID = "org.jbpm.gd.jpdl.script";

	/**
	 * The Semantic element ID for the Action Semantic Element
	 */
	public static final String ACTION_SEID = "org.jbpm.gd.jpdl.action";

	/**
	 * The Semantic element ID for the Controller Semantic Element
	 */
	public static final String CONTROLLER_SEID = "org.jbpm.gd.jpdl.controller";

	/**
	 * The Semantic element ID for the Task Semantic Element
	 */
	public static final String TASK_SEID = "org.jbpm.gd.jpdl.task";
	
	/**
	 * The Semantic element ID for the Event Semantic Element
	 */
	public static final String EVENT_SEID = "org.jbpm.gd.jpdl.event";

	/**
	 * The Semantic element ID for the Create Timer Semantic Element
	 */
	public static final String CREATE_TIMER_SEID = "org.jbpm.gd.jpdl.createTimer";
	
	/**
	 * The Semantic element ID for the Generic Element Semantic Element
	 */
	public static final String GENERIC_ELEMENT_SEID = "org.jbpm.gd.jpdl.genericElement";
	
	/**
	 * The Semantic element ID for the Variable Semantic Element
	 */
	public static final String VARIABLE_SEID = "org.jbpm.gd.jpdl.variable";
	
	/**
	 * The Semantic element ID for the Resource Type Semantic Element
	 */
	public static final String RESOURCETYPE_SEID = "com.tandbergtv.watchpoint.studio.resourceType";	
	
	/**
	 * The Semantic element ID for the Resource Group Semantic Element
	 */
	public static final String RESOURCEGROUP_SEID = "com.tandbergtv.watchpoint.studio.resourceGroup";	
	
	/**
	 * The Semantic element ID for the Protection Key Semantic Element
	 */
	public static final String PROTECTIONKEY_SEID = "org.jbpm.gd.jpdl.protectionKey";		
	
	/**
	 * The Semantic element ID for the Condition Semantic Element
	 */
	public static final String CONDITION_SEID = "org.jbpm.gd.jpdl.condition";
	
	/**
	 * The Semantic element ID for the Description Semantic Element
	 */
	public static final String DESCRIPTION_SEID = "org.jbpm.gd.jpdl.description";
	
	/**
	 * The Semantic element ID for the Superstate Semantic Element
	 */
	public static final String SUPERSTATE_SEID = "com.tandbergtv.watchpoint.studio.superstateNodeDefinition";
	
	/**
	 * The Semantic element ID for the StartNode Semantic Element
	 */
	public static final String STARTSTATE_SEID = "org.jbpm.gd.jpdl.startState";
	
	/**
	 * The Semantic element ID for the EndNode Semantic Element
	 */
	public static final String ENDSTATE_SEID = "org.jbpm.gd.jpdl.endState";
	
	/**
	 * The Semantic element ID for the LoopNode Semantic Element
	 */
	public static final String LOOPNODE_SEID = "org.jbpm.gd.jpdl.loopNode";
	
	
}
