/**
 * MutableTreeNode.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model.tree.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.tree.ITreeNode;

/**
 * A mutable tree node that allows its data to be modified
 * 
 * @author Sahil Verma
 */
public class MutableTreeNode<T> implements ITreeNode<T> {

	private T data;
	
	private ITreeNode<T> parent;
	
	private List<ITreeNode<T>> children;
	
	/**
	 * @param data
	 */
	public MutableTreeNode(T data) {
		this.data = data;
		this.children = new ArrayList<ITreeNode<T>>();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public List<ITreeNode<T>> getChildren() {
		return this.children;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean hasChildren() {
		return this.children.size() > 0;
	}

	/**
	 * {@inheritDoc}
	 */
	public T getData() {
		return this.data;
	}

	/**
	 * @param data the data to set
	 */
	public void setData(T data) {
		this.data = data;
	}

	/**
	 * {@inheritDoc}
	 */
	public ITreeNode<T> getParent() {
		return this.parent;
	}

	/**
	 * @param parent the parent to set
	 */
	public void setParent(ITreeNode<T> parent) {
		this.parent = parent;
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeChild(ITreeNode child) {
		Iterator<ITreeNode<T>> i = this.children.iterator();
		
		while (i.hasNext()) {
			ITreeNode<T> node = i.next();
			
			if (node.equals(child)) {
				i.remove();
				
				if (node instanceof MutableTreeNode)
					((MutableTreeNode<T>) node).setParent(null);
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public void addChild(ITreeNode<T> child) {
		this.children.add(child);
		
		if (child instanceof MutableTreeNode) {
			MutableTreeNode<T> node = (MutableTreeNode<T>) child;
			
			node.setParent(this);
		}
	}
}
