/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;

/**
 * Property section for viewing/setting the due date of an element.
 * 
 * @author Imran Naqvi
 *
 */
public class DueDateElementSection extends AbstractPropertySection {
	
	private DueDateElementConfigurationComposite dueDateElementConfigurationComposite;
	private IDueDateElement dueDateElement;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite, org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        dueDateElementConfigurationComposite = DueDateElementConfigurationComposite.create(this, getWidgetFactory(), clientArea);
    }
 
 	/* (non-Javadoc)
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
 	 */
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	IDueDateElement nodeSelected = (IDueDateElement)notationElement.getSemanticElement();
        	setDueDateElement(nodeSelected);
        } else if (input instanceof OutlineEditPart) {
        	IDueDateElement nodeSelected = (IDueDateElement)((OutlineEditPart)input).getModel();
        	setDueDateElement(nodeSelected);
        }
    }
 	
 	/* (non-Javadoc)
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
 	 */
 	public void refresh() {
 		if (dueDateElement != null) {
 			dueDateElementConfigurationComposite.setDueDateElement(dueDateElement);
 		}
    }
 	
 	/**
 	 * Sets the due date element.
 	 * 
 	 * @param dueDateElement
 	 */
 	private void setDueDateElement(IDueDateElement dueDateElement) {
 		this.dueDateElement = dueDateElement;
 	}

}
