package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ExceptionHandler;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * 		
 * @author <a href="francisco.neto@venturus.org.br">xfranet Francisco Bento da Silva Neto</a>
 *
 */
public class RollbackFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if (this.container == null)
			return false;

		if (!(modelElement instanceof NodeDefinition))
			return false;

		NodeDefinition node = NodeDefinition.class.cast(modelElement);

		// Just for single nodes. No SuperState
		if (NodeDefinitionType.MessageNode.equals(node.getNodeType()) && node.getNode() != null) {
			if (node.getNode().getExceptionHandlers().length > 0) {
				ExceptionHandler exceptionHandler = node.getNode().getExceptionHandlers()[0];

				ActionElement[] actions = exceptionHandler.getActionElements();
				if (actions != null && actions.length > 0) {
					if (actions[0] instanceof Action) {
						Action action = (Action)actions[0];
						if ("Rollback".equals(action.getClassName())) {
							return true;
						}
					}
				}
			}
		}
		
		return false;
	}
}
