/**
 * AbstractMultiDiffCommand.java
 * Created Apr 16, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.command;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.command.AbstractCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;

/**
 * @author Sahil Verma
 */
public abstract class AbstractMultiDiffCommand extends AbstractCommand {
	
	protected List<IDiff> diffs;
	
	/**
	 * @param name
	 * @param description
	 */
	protected AbstractMultiDiffCommand(String name, String description) {
		this(name, description, true);
	}

	/**
	 * @param name
	 * @param description
	 * @param enabled
	 */
	protected AbstractMultiDiffCommand(String name, String description, boolean enabled) {
		this(name, description, enabled, new ArrayList<IDiff>());
	}
	
	/**
	 * @param name
	 * @param description
	 * @param enabled
	 * @param diffs
	 */
	protected AbstractMultiDiffCommand(String name, String description, boolean enabled, List<IDiff> diffs) {
		super(name, description, enabled);
		this.diffs = diffs;
	}
	
	/**
	 * Gets the diffs
	 * 
	 * @return the diffs
	 */
	public List<IDiff> getDiffs() {
		return diffs;
	}
	
	/**
	 * Adds the specified diff to the end of the list
	 * 
	 * @param diff
	 */
	public void addDiff(IDiff diff) {
		this.diffs.add(diff);
	}
}
