/**
 * Diff.java
 * Created Apr 12, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.impl;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.sync.DiffKind;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;

/**
 * A basic implementation of {@link IDiff}. Subclasses can annotate this class with more information,
 * if required.
 * 
 * @author Sahil Verma
 */
public class Diff implements IDiff {

	private IWatchPointDTO model;
	
	private final SemanticElement element;
	
	private String attribute;
	
	private DiffKind kind;
	
	public static final Diff BLANK = new Diff(DiffKind.NONE);
	
	/**
	 * @param kind
	 */
	private Diff(DiffKind kind) {
		this.kind = kind;
		this.element = null;
	}
	
	/**
	 * @param element
	 * @param kind
	 */
	public Diff(SemanticElement element, DiffKind kind) {
		this(null, element, kind);
	}

	/**
	 * @param model
	 * @param kind
	 */
	public Diff(IWatchPointDTO model, DiffKind kind) {
		this(model, null, kind);
	}

	/**
	 * @param model
	 * @param kind
	 */
	public Diff(IWatchPointDTO model, SemanticElement element, DiffKind kind) {
		super();
		this.model = model;
		this.kind = kind;
		this.element = element;
	}

	/**
	 * @param element
	 * @param attribute
	 * @param kind
	 */
	public Diff(SemanticElement element, String attribute, DiffKind kind) {
		super();
		this.element = element;
		this.attribute = attribute;
		this.kind = kind;
	}

	/**
	 * @return the model
	 */
	public IWatchPointDTO getModel() {
		return model;
	}

	/**
	 * {@inheritDoc}
	 */
	public SemanticElement getElement() {
		return element;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getAttribute() {
		return this.attribute;
	}

	/**
	 * {@inheritDoc}
	 */
	public DiffKind getKind() {
		return kind;
	}
	
	public void setKind(DiffKind kind) {
		this.kind = kind;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		if (this.element != null)
			return element + " " + kind;
		
		return this.model + " " + kind;
	}
}
