/**
 * AddNodeCommand.java
 * Created Apr 16, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * A command that adds a node to a resource type
 * 
 * @author Sahil Verma
 */
public class AddNodeCommand extends AbstractNodeCommand {

	/**
	 * Creates an {@link AddNodeCommand}
	 * 
	 * @param name
	 * @param diff
	 */
	public AddNodeCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		super.execute();

		context.createNode(model);
	}

	/**
	 * If the message already exists in the repository, set the ID so that the relationships are preserved
	 */
	protected void updateRelationships() {
		ResourceType type = this.model.getResourceType();
		
		for (Message message : this.model.getMessages()) {
			String uid = message.getUid();
			
			if (type.getMessage(uid) != null)
				message.setId(type.getMessage(uid).getId());
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Node " + model.getName() + " " + diff.getKind();
	}
}
