/**
 * RemoveVariableCommand.java
 * Created Apr 22, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.template;

import static com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType.MessageNode;

import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Removes a variable from a template
 * 
 * @author Sahil Verma
 */
public class RemoveVariableCommand extends AbstractVariableCommand {
	
	protected NodeDefinitionDTO node;

	/**
	 * @param name
	 * @param diff
	 * @param context
	 */
	public RemoveVariableCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * @return the node
	 */
	public NodeDefinitionDTO getNode() {
		return node;
	}

	/**
	 * @param node the node to set
	 */
	public void setNode(NodeDefinitionDTO node) {
		this.node = node;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		WorkflowTemplate template = (WorkflowTemplate) container;
		
		for (NodeElement element : template.findNodes(this.node.getId())) {
			NodeDefinition node = (NodeDefinition) element;
			
			if (variable.isCompositeKey())
				removeCompositeKey(node);
			else
				removeVariable(node);
		}
	}
	
	protected void removeVariable(NodeDefinition node) {
		if (node.getNodeType() == MessageNode)
			((IMessageContainer) node.getNode()).removeVariable(variable.getMappedName());
		else
			node.removeVariable(variable.getMappedName());
	}
	
	protected void removeCompositeKey(NodeDefinition node) {
		((IMessageContainer) node.getNode()).removeCompositeKey(variable.getMappedName());
	}
}
