package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.io.File;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

public class SelectFilesAndDirsPage extends AbstractWizardPage {

	private static final String EMPTY_STRING = "";
		
	private String[] filterExtensions;
	
	private boolean dirsAllowed;
	
	private String labelText;
	
	private List listBox;
	
	public SelectFilesAndDirsPage(String pageName, boolean dirsAllowed) {
		super(pageName);
		this.dirsAllowed = dirsAllowed;
		setLabel(EMPTY_STRING);
	}

	public void setFilterExtensions(String[] filterExtensions) {
		this.filterExtensions = filterExtensions;
	}
	
	public String[] getFilterExtensions() {
		return this.filterExtensions;
	}
	
	/**
	 * Setting label to null will internally set as empty string
	 * 
	 * @param label
	 */
	public void setLabel(String label) {
		this.labelText = (label != null) ? label : EMPTY_STRING;
	}
	
	public String getLabel() {
		return this.labelText;
	}
	
	/*
	 * @see org.eclipse.swt.widgets.List#getItems()
	 */
	public String[] getItems() {
		return this.listBox.getItems();
	}
	
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite composite = createClientArea(parent);

		createFilesAndDirsControl(composite);

		setControl(composite);
		initialize(getDialogSettings());
		Dialog.applyDialogFont(composite);
	}

	/*
	 * Sets the layout of the client area.
	 * 
	 * @param parent
	 *            the parent composite of the client area
	 * @return the composite representing the client area
	 */
	private Composite createClientArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		FormLayout layout = new FormLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		composite.setLayout(layout);
		return composite;
	}
	
	private void createFilesAndDirsControl(Composite parent) {
		//controls creation
		//label
		Label label = new Label(parent, SWT.NONE);
		label.setText(this.labelText);
		
		//listbox
		listBox = new List(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		
		//addFiles button
		Button addFilesButton = new Button(parent, SWT.PUSH);
		addFilesButton.setText("Add Files");
		addFilesButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				for(String filePath : getFilePathsFromUser())
					listBox.add(filePath);
				
			}
		});
		
		//addDir button
		Button addDirButton = null;
		if(dirsAllowed) {
			addDirButton = new Button(parent, SWT.PUSH);
			addDirButton.setText("Add Folder");
			addDirButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					String dirPath = getDirPathFormUser();
					if(dirPath != null && dirPath.trim().length() > 0)
						listBox.add(dirPath);
				}
			});
		}
		
		//remove button
		Button removeButton = new Button(parent, SWT.PUSH);
		removeButton.setText("Remove");
		removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				listBox.remove(listBox.getSelectionIndices());
			}
		});
		
		//layout
		//label
		FormData labelFD = new FormData();
		labelFD.left = new FormAttachment(0);
		label.setLayoutData(labelFD);
	
		//listbox
		FormData listBoxFD = new FormData();
		listBoxFD.top = new FormAttachment(label, 10);
		listBoxFD.left = new FormAttachment(0);
		listBoxFD.right = new FormAttachment(100, -10);
		listBoxFD.bottom = new FormAttachment(addFilesButton, -10);
		listBox.setLayoutData(listBoxFD);
		
		//addFiles button
		FormData addFileButtonFD = new FormData();
		//addFileButtonFD.top = new FormAttachment(listBox, 10);
		addFileButtonFD.bottom = new FormAttachment(100);
		addFileButtonFD.left = new FormAttachment(0);
		addFilesButton.setLayoutData(addFileButtonFD);
		
		//addDir button
		if(addDirButton != null) {
			FormData addDirButtonFD = new FormData();
			addDirButtonFD.bottom = new FormAttachment(100);
			addDirButtonFD.left = new FormAttachment(addFilesButton, 5);
			addDirButton.setLayoutData(addDirButtonFD);
		}
			
		
		//remove button
		FormData removeButtonFD = new FormData();
		removeButtonFD.bottom = new FormAttachment(100);
		removeButtonFD.left = new FormAttachment((addDirButton != null) ? addDirButton : addFilesButton, 5);
		removeButton.setLayoutData(removeButtonFD);
	}
	
	protected void initialize(IDialogSettings settings) {
		String [] items = settings.getArray(getName());
		
		if (items != null)
			listBox.setItems(items);
	}

	private String[] getFilePathsFromUser() {
		FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(),
				SWT.SYSTEM_MODAL | SWT.MULTI);
		fileDialog.setText("Select File(s)");
		if(this.filterExtensions != null)
			fileDialog.setFilterExtensions(this.filterExtensions);
		fileDialog.open();

		String[] filePaths = new String[fileDialog.getFileNames().length];
		int index = 0;
		for(String fileName : fileDialog.getFileNames()) {
			filePaths[index++] = fileDialog.getFilterPath() + File.separator + fileName;
		}
		return filePaths;
	}
	
	private String getDirPathFormUser() {
		DirectoryDialog dirDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(),
				SWT.SYSTEM_MODAL);
		dirDialog.setText("Select Folder");
		return dirDialog.open();
	}
	
	/**
	 * {@inheritDoc}
	 */
	protected void saveSettings(IDialogSettings settings) {
		settings.put(getName(), listBox.getItems());
	}
}
