package com.tandbergtv.watchpoint.studio.ui.wizard.template;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.jbpm.gd.jpdl.prefs.JbpmInstallation;
import org.jbpm.gd.jpdl.prefs.PreferencesManager;
import org.jbpm.gd.jpdl.wizard.NewWatchpointTemplateProjectWizardCustom;

import com.tandbergtv.watchpoint.studio.builder.WatchpointTemplateNature;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;

/**
 * 	Wizard based on JBPM's org.jbpm.gd.jpdl.wizard.NewProcessDefinitionWizard.
 *  Code replication is required to change labels and messages.
 * 
 * @author <a href="francisco.neto@venturus.org.br">xfranet - Francisco Bento da Silva Neto</a>
 * @see org.jbpm.gd.jpdl.wizard.NewProcessDefinitionWizard
 *
 */
public class NewWatchpointTemplateProjectWizard extends NewWatchpointTemplateProjectWizardCustom {	
	@Override
	public void createSimpleProcessDefinition(IJavaProject javaProject) throws CoreException, JavaModelException, IOException {
		JbpmInstallation jbpmInstallation = PreferencesManager.INSTANCE.getJbpmInstallation(getCoreJbpmName());
		if (jbpmInstallation == null) return;
		IFolder folder = javaProject.getProject().getFolder("src/main/jpdl/simple");
		if (!folder.exists()) {
			folder.create(true, true, null);
		}
		copyJbpmResource(this.getClass().getResourceAsStream(WorkflowTemplateDTO.TEMPLATE_DEFINITION_FILE_NAME), "simple." + WorkflowTemplateDTO.TEMPLATE_DEFINITION_FILE_EXTENSION_NAME, folder);
		copyJbpmResource(this.getClass().getResourceAsStream(WorkflowTemplateDTO.GPD_FILE_NAME), WorkflowTemplateDTO.GPD_FILE_NAME, folder);
		copyJbpmResource(this.getClass().getResourceAsStream(WorkflowTemplateDTO.TEMPLATE_IMAGE_FILE_NAME), WorkflowTemplateDTO.TEMPLATE_IMAGE_FILE_NAME, folder);
	}

	/**
	 * Add Template Nature on a project
	 * 
	 * @param project
	 *            to have Watchpoint Template nature added 
	 */
	@Override
	public void addNature(IProject project) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();

			// Add the nature
			String[] newNatures = new String[natures.length + 1];
			System.arraycopy(natures, 0, newNatures, 0, natures.length);
			newNatures[natures.length] = WatchpointTemplateNature.NATURE_ID;
			description.setNatureIds(newNatures);
			project.setDescription(description, null);
		} catch (CoreException e) {
			ErrorDialog.openError(getShell(), "Problem creating java project", null, null);
		}
	}
	
}