package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * The Dom Adaptor class for a workflow template.
 * 
 * @author Imran Naqvi
 * 
 */
public class WorkflowTemplateDomAdapter extends ProcessDefinitionDomAdapter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter#getNodeTypes()
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Map<String, String> getNodeTypes() {
		Map<String, String> types = super.getNodeTypes();
		types.put("loop", "node-element");
		types.put("nodeDefinition", "node-element");
		types.put("auto-task", "node-element");
		types.put("manual-task", "node-element");
        types.put("assign", "node-element");
		types.put("protection-key", "protection-key");
		return types;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if ("pkAdd".equals(evt.getPropertyName()))
			addElement((ProtectionKey) evt.getNewValue());
		else if ("pkRemove".equals(evt.getPropertyName()))
			removeElement((ProtectionKey) evt.getOldValue());
		else if ("version".equals(evt.getPropertyName()))
			setAttribute("version", evt.getNewValue().toString());
		else
			super.propertyChange(evt);
	}

	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		WorkflowTemplate template = (WorkflowTemplate) jpdlElement;

		String versionStr = template.getProperty("version");
		
		try {
			if (versionStr != null) {
				template.setVersion(Integer.parseInt(versionStr));
			}
		} catch (NumberFormatException n) {}
	}

	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter#doModelUpdate(java.lang.String,
	 *      java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue) {
		WorkflowTemplate template = (WorkflowTemplate) getSemanticElement();
		if ("version".equals(name)) {
			template.setVersion(Integer.parseInt(newValue));
		}
		else
			super.doModelUpdate(name, newValue);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		String type = child.getElementType();
		SemanticElement jpdlElement = createSemanticElementFor(child);
		if (jpdlElement == null)
			return;
		WorkflowTemplate template = (WorkflowTemplate) getSemanticElement();
		if ("protection-key".equals(type)) {
			child.initialize(jpdlElement);
			template.addProtectionKey((ProtectionKey) jpdlElement);
		}
		else if ("auto-task".equals(type) || "manual-task".equals(type)
				|| "nodeDefinition".equals(type)) {
			child.initialize(jpdlElement);
			template.addNodeElement((AbstractNode) jpdlElement);
		} else if("loop".equals(type)){
			child.initialize(jpdlElement);
			template.addNodeElement((AbstractNode) jpdlElement);
		}
		else
			super.doModelAdd(child);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.ProcessDefinitionDomAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		String type = child.getElementType();
		WorkflowTemplate template = (WorkflowTemplate) getSemanticElement();
		if ("protection-key".equals(type)) {
			template.removeProtectionKey((ProtectionKey) child.getSemanticElement());
		}
		else if ("auto-task".equals(type) || "manual-task".equals(type)
				|| "nodeDefinition".equals(type) || "node-element".equals(type) || "loop".equals(type) || "assign".equals(type)) {
			template.removeNodeElement((AbstractNode) child.getSemanticElement());
		}
		else
			super.doModelRemove(child);
	}
}
