package com.tandbergtv.watchpoint.studio.usermgmt;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

import org.apache.log4j.Logger;

public class UserManager {
	private static final Logger logger = Logger.getLogger(UserManager.class);
	private static UserManager instance;
	private User currentUser;
	private IUserIdGenerator idGenerator;

	/**
	 * Constructor.
	 */
	private UserManager() {
		this.currentUser = this.createUser();
		idGenerator = new DefaultUserIdGenerator();
	}

	/** 
	 * Gets the singleton instance of this class. 
	 * @return The UserManager Instance 
	 */
	public static UserManager getInstance() {
		if (instance == null) {
			instance = new UserManager();
		}
		return instance;
	}

	/**
	 * Creates a user
	 * 
	 * @return user
	 */
	private User createUser() {
		String userId = System.getProperty("user.name");
		InetAddress addr = null;
		String ipAddr = "";
		try {
			addr = InetAddress.getLocalHost();
			ipAddr = addr.getHostAddress();
		} catch (UnknownHostException e) {
			logger.error("Unable to get the IP Address:  " + e.getMessage());

		}

		User user = new User(userId, ipAddr, System.currentTimeMillis(),
				new Random().nextInt());
		return user;
	}

	/**
	 * @return the Cuurentuser
	 */
	public User getCurrentUser() {
		return currentUser;
	}



	/*
	 * (non-Javadoc)
	 * 
	 * @see com.tandbergtv.watchpoint.studio.usermgmt.UserGeneration#generateUserId()
	 */
	public String getCurrentUserId() throws UserManagementException {
		
		return idGenerator.generateUserId(currentUser);
	}

	/**
	 * @param user The User
	 * @return the User Id
	 * @throws UserManagementException 
	 */
	public String getUserId(User user) throws UserManagementException {
		return idGenerator.generateUserId(user);
	}
	
	/**
	 * @param userId The User Id
	 * @return the User
	 * @throws UserManagementException 
	 */
	public User getUser(String userId) throws UserManagementException {
		return idGenerator.generateUser(userId);
	}
}
