/*
 * Created on Nov 12, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.model;

import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Class that represents an instance of a Node Definition that could be part of a Workflow Template
 * or another Super State Node Definition.
 * 
 * @param <NEC>
 *            The type of the container that contains this node definition instance
 * 
 * @author Vijay Silva
 */
public class NodeDefinitionInstance
{
	protected NodeElementContainer container;

	protected NodeDefinition nodeInstance;

	/**
	 * Constructor
	 * 
	 * @param nodeInstance
	 *            The Node Instance
	 * @param parent
	 *            The container (either Template or Node Definition) that contain this node
	 *            instance.
	 */
	public NodeDefinitionInstance(NodeDefinition nodeInstance, NodeElementContainer parent)
	{
		this.container = parent;
		this.nodeInstance = nodeInstance;
	}

	/**
	 * Get the Container which this node definition instance is part of.
	 * 
	 * @return the parent container
	 */
	public NodeElementContainer getContainer()
	{
		return this.container;
	}

	/**
	 * Get the Node Definition node instance.
	 * 
	 * @return The Node Definition node instance.
	 */
	public NodeDefinition getNodeInstance()
	{
		return this.nodeInstance;
	}
}
