package org.jbpm.gd.common.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.registry.RegistryRegistry;
import org.jbpm.gd.common.registry.XmlAdapterRegistry;
import org.jbpm.gd.jpdl.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * 		Class intended to speed up the UI Model parsing based on the XML DOM model, instead of the eclipse SSE API.		
 * 		Although its not recommended, this class had to be present in this package due to the method org.jbpm.gd.common.xml.XmlAdapter.setFactory(XmlAdapterFactory) which is
 * package-protected.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class SimpleDOMAdapterFactory extends XmlAdapterFactory {

	private XmlAdapterRegistry xmlAdapterRegistry;
	private Document document;
	
	public SimpleDOMAdapterFactory(Document document, SemanticElementFactory elementFactory) {
		super(document, elementFactory);
		xmlAdapterRegistry = RegistryRegistry.getXmlAdapterRegistry(elementFactory.getEditorId());
		this.document = document;
	}

	@Override
	public XmlAdapter adapt(Node node) {
		return (XmlAdapter) createAdapter(node);
	}
	
	/**
	 * 		Analog to org.jbpm.gd.common.xml.XmlAdapterFactory.createAdapter(INodeNotifier) but based on the DOM model instead of SSE model.
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapterFactory.createAdapter(INodeNotifier)
	 * @param target
	 * @return
	 */
	protected XmlAdapter createAdapter(Node target) {
		return super.createAdapterWithoutChecking(target);
	}
	

	@Override
	public XmlAdapter createAdapterFromModel(SemanticElement semanticElement) {
		return super.createAdapterFromModel(xmlAdapterRegistry, semanticElement);
	}
	
	/**
	 * 		Analog to org.jbpm.gd.common.xml.XmlAdapterFactory.createAdapter(IConfigurationElement, String) but based on the DOM model instead of SSE model.
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapterFactory.createAdapter(IConfigurationElement, String)
	 * @param target
	 * @return
	 */
	@Override
	protected XmlAdapter createAdapter(IConfigurationElement configurationElement, String elementName) {
		return super.createAdapterFromDoc(configurationElement, elementName, document);
	}
	
	
}