package com.tandbergtv.watchpoint.studio.debugger.model;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * 		Stores the SimulationData for each node
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class SimulationData {
	
	@SuppressWarnings("rawtypes")
	protected Map simulationAttributes;

	@SuppressWarnings("rawtypes")
	public SimulationData(Map simulationAttributes) {
		if (simulationAttributes == null) {
			simulationAttributes = new HashMap();
		}
		this.simulationAttributes = simulationAttributes;
	}
	
	@SuppressWarnings("rawtypes")
	public SimulationData() {
		this.simulationAttributes = new HashMap();
	}

	public Object getAttribute(String key) {
		return simulationAttributes.get(key);
	}
	
	@SuppressWarnings("unchecked")
	public Object setAttribute(String key, Object value) {
		return simulationAttributes.put(key, value);
	}
	
	@SuppressWarnings("rawtypes")
	public Map getAttributes() {
		return simulationAttributes;
	}

}
