/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationData;
import com.tandbergtv.watchpoint.studio.debugger.runtime.TemplateSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Commands;
import com.tandbergtv.workflow.core.WorkflowProcess;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;

public class RuntimeLauncher
extends TemplateSimulator {
    private String dir;
    private static final Logger logger = Logger.getLogger(RuntimeLauncher.class);

    public RuntimeLauncher(ProcessDefinition template, Map<String, NodeSimulationConfig> map, String dir) {
        super(template, map);
        this.dir = dir;
    }

    @Override
    public void startSimulation() {
        try {
            WorkflowProcess process = Commands.create(this.template, this.getInitialParameters(this.template.getStartState()));
            process.getContextInstance().setTransientVariable("_simulationconfig", (Object)this.configs);
            process.getContextInstance().setTransientVariable("__dir", (Object)this.dir);
        }
        catch (Exception e) {
            logger.error((Object)":(", (Throwable)e);
        }
    }

    private Map<String, Object> getInitialParameters(Node node) {
        SimulationData sd = ((NodeSimulationConfig)this.configs.get(node.getName())).getSimulationData();
        return new ParameterizableSimulationData(sd).getVariables();
    }
}

