/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.exe;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.tandbergtv.watchpoint.studio.debugger.runtime.Services;
import com.tandbergtv.watchpoint.studio.debugger.runtime.hibernate.HibernateUtil;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.ServiceLifecycleListener;
import com.tandbergtv.workflow.driver.internal.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class Lifecycle {
    private static final Logger logger = Logger.getLogger(Lifecycle.class);

    public static void start() {
        Lifecycle.startHazelcast();
        HibernateUtil.initialize();
        SessionFactory factory = HibernateUtil.getSessionFactory();
        ServiceLifecycleListener listener = new ServiceLifecycleListener();
        Services.addService((Service)listener);
        Services.addService((Service)new CompositeCache("Process Cache", 64));
        Properties properties = new Properties();
        properties.setProperty("template.max.count", "64");
        Services.addService((Service)new TemplateLoaderService(properties, factory));
        Services.addService((Service)new RecoverableDistributedScheduler("distributed-scheduler", 1));
        Services.addService((Service)new DistributedScheduler("one-shot-distributed-scheduler", 1));
        Services.addService((Service)new HibernatePersistenceService(factory));
        Services.addService((Service)new ProcessManager(Lifecycle.getProperties()));
    }

    public static void stop() {
        block2: {
            Services.removeService(IPersistenceService.class);
            Services.removeService(IProcessManagerService.class);
            Services.removeService("Process Cache");
            Services.removeService(ITemplateLoaderService.class);
            Services.removeService("one-shot-distributed-scheduler");
            Services.removeService("distributed-scheduler");
            Services.removeService(ServiceLifecycleListener.class);
            HibernateUtil.close();
            Hazelcast.getLifecycleService().shutdown();
            Hazelcast.shutdownAll();
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException e) {
                int code = e.getErrorCode();
                String state = e.getSQLState();
                if (code == 50000 && "XJ015".equals(state)) break block2;
                logger.error((Object)("Database didn't die :(, code=" + code + " state=" + state), (Throwable)e);
            }
        }
    }

    private static void startHazelcast() {
        System.setProperty("hazelcast.logging.type", "log4j");
        Config config = new Config();
        config.getGroupConfig().setPassword(UUID.randomUUID().toString());
        Hazelcast.init((Config)config);
    }

    private static Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("isDriverHalted", "false");
        properties.setProperty("no.retry.on.recovery", "false");
        properties.setProperty("log.level", LogLevel.DEBUG.toString());
        properties.setProperty("pool.size", "2");
        return properties;
    }
}

