/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractNodeSimulationComposite
extends Composite
implements SelectionListener {
    protected FormToolkit toolkit;
    protected NodeSimulationConfig nodeSimulationConfig;
    protected Label lblNodeType;
    protected Label lblNodeName;
    protected Collection<Button> btnSimulationTypes = new ArrayList<Button>();
    protected List<SimulationModifyListener> simulationModifyListeners = new ArrayList<SimulationModifyListener>();
    protected WorkflowTemplate template;

    public AbstractNodeSimulationComposite(Composite parent, NodeSimulationConfig nodeConfig) {
        super(parent, 0);
        this.nodeSimulationConfig = nodeConfig;
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.initializeCompositeData();
        this.createDefaultControls();
        this.createAdditionalControls(this);
    }

    protected void initializeCompositeData() {
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(2, false));
    }

    protected void createNodeNameWidget(Composite composite) {
        Label lblName = new Label(composite, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText("Name :");
        this.lblNodeName = new Label(composite, 0);
    }

    protected void createNodeTypeWidget(Composite composite) {
        Label lblType = new Label(composite, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("Type :");
        this.lblNodeType = new Label(composite, 0);
    }

    protected void createSimulationTypeWidget(Composite composite) {
        Label lblSimulationType = new Label(composite, 0);
        lblSimulationType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSimulationType.setText("Simulation Type :");
        Composite simulationTypeComposite = this.toolkit.createComposite(composite, 0);
        simulationTypeComposite.setBackground(composite.getBackground());
        this.toolkit.paintBordersFor(simulationTypeComposite);
        simulationTypeComposite.setLayout((Layout)new GridLayout(5, false));
        SimulationType[] simulationTypeArray = this.getSimulationTypes();
        int n = simulationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulationType simulationType = simulationTypeArray[n2];
            Button btnSimulationType = new Button(simulationTypeComposite, 16);
            btnSimulationType.setData((Object)simulationType);
            btnSimulationType.addSelectionListener((SelectionListener)this);
            btnSimulationType.setText(simulationType.getLabel());
            this.btnSimulationTypes.add(btnSimulationType);
            ++n2;
        }
    }

    protected void createDefaultControls() {
        this.createNodeNameWidget(this);
        this.createNodeTypeWidget(this);
        this.createSimulationTypeWidget(this);
    }

    protected abstract void createAdditionalControls(Composite var1);

    public void load(NodeSimulationConfig nodeSimulationConfig) {
        this.lblNodeName.setText(nodeSimulationConfig.getNodeElement().getName());
        this.lblNodeType.setText(nodeSimulationConfig.getNodeElement().getLabel());
        for (Button button : this.btnSimulationTypes) {
            if (button.getData().equals((Object)nodeSimulationConfig.getSimulationType())) {
                button.setSelection(true);
                continue;
            }
            button.setSelection(false);
        }
    }

    protected abstract SimulationType[] getSimulationTypes();

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public NodeSimulationConfig getNodeSimulationConfig(NodeSimulationConfig config) {
        return config;
    }

    public void addSimulationModifyListener(SimulationModifyListener listener) {
        this.simulationModifyListeners.add(listener);
    }

    protected void fireSimulationModifiedEvent(Object o) {
        for (SimulationModifyListener listener : this.simulationModifyListeners) {
            listener.modifySimulation(o);
        }
    }

    public void setTemplate(WorkflowTemplate template) {
        this.template = template;
    }
}

