/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.ui.AbstractNodeSimulationComposite;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationConfigFactory;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationTable;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationWidgetFactory;
import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.debugger.util.DebuggerUtils;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NodeSimulatorTab
extends AbstractLaunchConfigurationTab
implements SelectionListener {
    AbstractNodeSimulationComposite nodeSimulationComposite;
    NodeSimulationTable templateNodesTable;
    NodeSimulationConfig currentNode = null;
    Map<String, NodeSimulationConfig> simulationConfigMap = new HashMap<String, NodeSimulationConfig>();
    Group nodeSimulationGroup;
    Composite mainPanel = null;
    FormToolkit toolkit = null;
    protected String templatePath = "";
    protected WorkflowTemplate template;
    public static final String EMPTY_STRING = "";

    protected void createMainPanel(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        this.mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.mainPanel.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        this.mainPanel.setLayoutData((Object)gd);
    }

    protected void createTemplateNodesGroup() {
        Group grpTemplateNodes = new Group(this.mainPanel, 0);
        grpTemplateNodes.setLayout((Layout)new FillLayout(256));
        grpTemplateNodes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpTemplateNodes.setText("Template Nodes");
        this.toolkit.paintBordersFor((Composite)grpTemplateNodes);
        this.templateNodesTable = new NodeSimulationTable((Composite)grpTemplateNodes);
        this.templateNodesTable.addSelectionListener(this);
        this.templateNodesTable.addSimulationModifyListener(new SimulationModifyListener(){

            @Override
            public void modifySimulation(Object o) {
                NodeSimulatorTab.this.updateLaunchConfigurationDialog();
                if (NodeSimulatorTab.this.nodeSimulationComposite != null) {
                    NodeSimulatorTab.this.nodeSimulationComposite.load(NodeSimulatorTab.this.templateNodesTable.getSelection());
                }
            }
        });
    }

    protected void createNodeSimulationGroup() {
        this.nodeSimulationGroup = new Group(this.mainPanel, 0);
        this.nodeSimulationGroup.setBackground(this.mainPanel.getBackground());
        this.nodeSimulationGroup.setLayout((Layout)new FillLayout(256));
        GridData gridData = new GridData(4, 128, true, false, 1, 1);
        gridData.heightHint = 290;
        this.nodeSimulationGroup.setLayoutData((Object)gridData);
        this.nodeSimulationGroup.setText("Node Simulation Properties");
        this.toolkit.paintBordersFor((Composite)this.nodeSimulationGroup);
    }

    protected void createSeparator() {
        Label label = new Label(this.mainPanel, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    public void updateTemplate(String templatePath, ILaunchConfiguration config) {
        this.template = DebuggerUtils.parseWorkspaceTemplate(templatePath);
        Collection<Object> simulationData = Collections.EMPTY_LIST;
        if (this.template != null) {
            try {
                this.simulationConfigMap = NodeSimulationConfigFactory.createFactory().getNodesForSimulation(this.template, config.getAttributes());
                simulationData = this.simulationConfigMap.values();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.templateNodesTable.setSimulationData(simulationData);
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.createMainPanel(parent);
        this.createTemplateNodesGroup();
        this.createSeparator();
        this.createNodeSimulationGroup();
        this.setControl((Control)this.mainPanel);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String newTemplatePath = config.getAttribute("com.tandberg.watchpoint.studio.template", EMPTY_STRING);
            if (!newTemplatePath.equals(this.templatePath)) {
                if (this.nodeSimulationComposite != null) {
                    this.nodeSimulationComposite.dispose();
                }
                this.templatePath = newTemplatePath;
                this.updateTemplate(this.templatePath, config);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        for (NodeSimulationConfig nodeConfig : this.simulationConfigMap.values()) {
            Map nodeAttributes = nodeConfig.getSimulationData().getAttributes();
            String nodeName = nodeConfig.getNodeElement().getName();
            if (nodeConfig.getSimulationType() != null) {
                config.setAttribute(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName), nodeConfig.getSimulationType().getValue());
            } else {
                config.removeAttribute(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName));
            }
            String dataPrefix = TemplateLauncherConstants.getNodeSimulationDataKey(nodeName);
            for (Object keyObj : nodeAttributes.keySet()) {
                String key = keyObj.toString();
                String newKey = String.valueOf(dataPrefix) + "." + key;
                config.setAttribute(newKey, nodeAttributes.get(keyObj).toString());
            }
        }
    }

    public Image getImage() {
        return Utility.getImageDescriptor((String)"com.tandbergtv.watchpoint.studio.debugger", (String)"template_simulation_tab.png").createImage();
    }

    public String getName() {
        return "Node Simulation";
    }

    public void widgetSelected(SelectionEvent e) {
        NodeSimulationConfig selected = this.templateNodesTable.getSelection();
        boolean isSameNode = false;
        if (selected != null && this.currentNode != null && this.currentNode.getNodeElement().getName().equals(selected.getNodeElement().getName())) {
            isSameNode = true;
        }
        if (!isSameNode) {
            if (this.nodeSimulationComposite != null) {
                this.nodeSimulationComposite.dispose();
            }
            this.nodeSimulationComposite = NodeSimulationWidgetFactory.getCompositeForNode(this.templateNodesTable.getSelection(), (Composite)this.nodeSimulationGroup);
            this.nodeSimulationComposite.addSimulationModifyListener(new SimulationModifyListener(){

                @Override
                public void modifySimulation(Object o) {
                    NodeSimulatorTab.this.updateLaunchConfigurationDialog();
                    NodeSimulatorTab.this.templateNodesTable.updateNode((NodeSimulationConfig)o);
                }
            });
            this.nodeSimulationComposite.setTemplate(this.template);
            this.nodeSimulationComposite.load(this.templateNodesTable.getSelection());
            this.setControl((Control)this.mainPanel);
            ScrolledComposite sc = (ScrolledComposite)this.mainPanel.getParent();
            sc.setMinSize(this.mainPanel.computeSize(-1, -1));
            super.updateLaunchConfigurationDialog();
        }
        this.currentNode = selected;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

