package com.tandbergtv.watchpoint.studio.debugger.runtime;

import java.util.HashMap;
import java.util.Map;

import org.jbpm.graph.def.ProcessDefinition;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulatorFactory;

/**
 * 		Simulates a Template.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public abstract class TemplateSimulator {

	protected ProcessDefinition template = null;
	protected Map<String, NodeSimulationConfig> configs = new HashMap<String, NodeSimulationConfig>();
	protected NodeSimulatorFactory simulatorFactory;
	
	public TemplateSimulator(ProcessDefinition template, Map<String, NodeSimulationConfig> simulationConfigMap) {
		this.template = template;
		this.configs = simulationConfigMap;
		simulatorFactory = new NodeSimulatorFactory(simulationConfigMap);
	}
	
	public ProcessDefinition getTemplate() {
		return template;
	}
	
	public Map<String, NodeSimulationConfig> getSimulationConfigMap() {
		return configs;
	}

	public abstract void startSimulation();
	
}
