package com.tandbergtv.watchpoint.studio.builder;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

import com.tandbergtv.watchpoint.studio.ui.model.DataCollectionManager;

public class ResourceTypeDataCollectorVisitor implements IResourceDeltaVisitor, IResourceVisitor {

    @Override
    public boolean visit(IResource resource) throws CoreException {
        if (resource.getType() == IResource.FILE && "xml".equalsIgnoreCase(resource.getFileExtension())) {
            collectData(resource.getFullPath().toPortableString());
        }

        if (resource.getType() == IResource.FOLDER
                && ("resources".equalsIgnoreCase(resource.getName()) || "node".equalsIgnoreCase(resource.getName()))
                || resource.getType() == IResource.PROJECT) {
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource().getType() == IResource.FOLDER
                && ("resources".equalsIgnoreCase(delta.getResource().getName()) || "node".equalsIgnoreCase(delta.getResource().getName()))
                || delta.getResource().getType() == IResource.PROJECT) {
            return true;
        }

        if (delta.getResource().getType() == IResource.FILE
                && "xml".equalsIgnoreCase(delta.getResource().getFileExtension())) {
            switch (delta.getKind()) {
            case IResourceDelta.ADDED:
                collectData(delta.getFullPath().toPortableString());
                break;
            case IResourceDelta.REMOVED:
                removeData(delta);
                break;
            case IResourceDelta.CHANGED:
                collectData(delta.getFullPath().toPortableString());
                break;
            }
        }

        return false;
    }

    private void removeData(IResourceDelta delta) {
        String resourceId = DataCollectionManager.getInstance().removeMessageNode(delta.getFullPath().toPortableString());
        if (resourceId == null) {
            resourceId = DataCollectionManager.getInstance().removeSuperstate(delta.getFullPath().toPortableString());
            if (resourceId == null) {
                DataCollectionManager.getInstance().removeResourceType(delta.getFullPath().toPortableString());
            }
        }
    }

    private void collectData(String fullPath) {
        String resourceId = DataCollectionManager.getInstance().collectMessageNode(fullPath);
        if (resourceId == null) {
            resourceId = DataCollectionManager.getInstance().collectSuperstate(fullPath);
            if (resourceId == null) {
                DataCollectionManager.getInstance().collectResourceType(fullPath);
            }
        }
    }
}