package com.tandbergtv.watchpoint.studio.builder.resolution;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IMarkerResolution;

/**
 * 		Base WatchpointStudio Resolution class.
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public abstract class WatchpointStudioResolution implements IMarkerResolution {

	protected IResource resource;
	protected Object element;
	protected Object message;
	
    public WatchpointStudioResolution() { }
	
    public WatchpointStudioResolution(IResource resource, Object element, Object message) {
        this.resource = resource;
        this.element = element;
        this.message = message;
    }

    public Object getMessage() {
		return message;
	}

	public void setMessage(Object message) {
		this.message = message;
	}

	public void setResource(IResource resource) {
		this.resource = resource;
	}
	
	public IResource getResource() {
		return resource;
	}
	
	public IFile getFile() {
		return (IFile) resource;
	}
	
	public void setElement(Object element) {
		this.element = element;
	}
	
	public Object getElement() {
		return element;
	}
	
	public abstract void run();
	
    @Override
    public void run(IMarker marker) {
        run();
    }
}
