package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;

public class WatchpointTemplateResolutionGenerator implements IMarkerResolutionGenerator {

    public static final String ERROR_CODE = "code";
    public static final String ERROR_ELEMENT = "element";

    @Override
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            String markersMessage = (String) marker.getAttribute(IMarker.MESSAGE);
            IResource markersResource = marker.getResource();
            Map<String, Object> validationAttributes = ValidationMessage.copyAttributesFrom(marker);
            String validationElement = (String) validationAttributes.get(ERROR_ELEMENT);
            String validationCode = (String) validationAttributes.get(ERROR_CODE);

            if (validationCode.equals(ValidationMessageCode.NODEDEFINITION_SUPERSTATE_OUTDATED.getCode())) {
                return new IMarkerResolution[] { new SuperStateOutdatedResolution(markersResource, validationElement, markersMessage) };
            } else if (validationCode.equals(ValidationMessageCode.NODEDEFINITION_MESSAGE_OUTDATED.getCode())) {
                return new IMarkerResolution[] { new MessageNodeOutdatedResolution(markersResource, validationElement, markersMessage) };
            } else if (validationCode.equals(ValidationMessageCode.TEMPLATE_START_NODE_VARIABLE_UNUSED.getCode())) {
                return new IMarkerResolution[] { new StartNodeVariableUnusedResolution(markersResource, validationElement, markersMessage) };
            } else if (validationCode.equals(ValidationMessageCode.NODE_VARIABLE_TYPE_MISMATCH_IN_TEMPLATE.getCode())) {
                return new IMarkerResolution[] { new VariableTypeDoesNotMatchResolution(markersResource, validationElement, markersMessage) };
            } else if (validationCode.equals(ValidationMessageCode.NODE_VARIABLE_NOT_MAPPED_IN_TEMPLATE.getCode())) {
                String validationVariableName = (String) validationAttributes
                        .get(ValidationRule.KEY_MISSING_MAPPING_VARIABLE_NAME);
                String validationVariableType = (String) validationAttributes
                        .get(ValidationRule.KEY_MISSING_MAPPING_VARIABLE_TYPE);
                
                if (validationAttributes.get(ValidationRule.KEY_CONTAINER_VARIABLES) == null) {
                    return new IMarkerResolution[0];
                }

                List<NodeVariableNotMappedInTemplateResolution> resolutions = new ArrayList<NodeVariableNotMappedInTemplateResolution>();
                for (WPVariable validationContainerVariable : (List<WPVariable>) validationAttributes
                        .get(ValidationRule.KEY_CONTAINER_VARIABLES)) {
                    if (validationContainerVariable.getType().trim().equalsIgnoreCase(validationVariableType)) {
                        resolutions.add(new NodeVariableNotMappedInTemplateResolution(markersResource, validationElement, validationVariableName,
                                validationContainerVariable));
                    }
                }

                return resolutions.toArray(new IMarkerResolution[0]);
            } else if (validationCode.equals(ValidationMessageCode.LOOPNODE_MISSING_INDEX_VARIABLE.getCode())) {
                return new IMarkerResolution[] { new LoopNodeWithoutIndexResolution(markersResource, validationElement) };
                
            } else if (validationCode.equals(ValidationMessageCode.LOOPNODE_MISSING_LIST_VARIABLE.getCode())) {
                return new IMarkerResolution[] { new LoopNodeWithoutListResolution(markersResource, validationElement) };
            }

            return new IMarkerResolution[0];
        } catch (CoreException e) {
            throw new RuntimeException(e);
        }
   }
}