/*
 * Created on Jul 31, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.util.ClassLoaderUtil;

/**
 * Abstract Factory used for instantiating Exporters
 * 
 * @author Vijay Silva
 */
public abstract class WatchPointDTOExporterFactory
{
	private static final String DEFAULT_FACTORY = "com.tandbergtv.watchpoint.studio.external.wpexport.impl.DefaultExporterFactory";

	/**
	 * Constructor
	 */
	protected WatchPointDTOExporterFactory()
	{
		super();
	}

	/**
	 * Return the configured Data Access Factory to use for creating Data Access Objects.
	 * 
	 * @return The DataAccessFactory
	 */
	public static WatchPointDTOExporterFactory createFactory()
	{
		return ClassLoaderUtil.createFactoryInstance(DEFAULT_FACTORY, WatchPointDTOExporterFactory.class);
	}

	/**
	 * Creates a new Exporter instance that can export the specified WatchPoint DTO object.
	 * 
	 * @param <T>
	 *            The type of the WatchPointDTO object to export
	 * @param exportObjectType
	 *            The Class of the object to export
	 * 
	 * @return The Exporter instance
	 */
	public abstract <T extends IWatchPointDTO> IWatchPointDTOExporter<T> getExporter(
			Class<T> exportObjectType);
}
