/**
 * NodeDefinitionWriter.java
 * Created Jan 26, 2010
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.GPD_EXTENSION;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.PLUGIN_NODE_FOLDER;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.PLUGIN_RESOURCE_FOLDER_NAME;
import static com.tandbergtv.watchpoint.studio.external.wpexport.impl.WatchPointPluginConstants.XML_EXTENSION;
import static java.io.File.separator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collection;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.util.XMLDocumentUtility;

/**
 * Writes out node definitions for a resource type to the resources/ directory of the corresponding
 * plugin
 * 
 * @author Sahil Verma
 */
public class NodeDefinitionFileSystemWriter {
	
	public void writeNodeDefinitionsInProject(Collection<NodeDefinitionDTO> nodes, IProject proj) throws Exception{
		for (NodeDefinitionDTO nodeDefinitionDTO : nodes) {
			String nodeFolderPath = separator + PLUGIN_RESOURCE_FOLDER_NAME + separator + PLUGIN_NODE_FOLDER;
			if (!proj.getFolder(nodeFolderPath).exists()){
				proj.getFolder(nodeFolderPath).create(true, true, null);
			}
			
			String xmlFilePath = nodeFolderPath +
			separator + nodeDefinitionDTO.getName() + XML_EXTENSION;
			String gpdFilePath = nodeFolderPath +
			separator + nodeDefinitionDTO.getName() + GPD_EXTENSION;
			
			writeNodeDefinitionFile(nodeDefinitionDTO.getXml(), xmlFilePath, proj);
			writeNodeDefinitionFile(nodeDefinitionDTO.getGpd(), gpdFilePath, proj);
		}
		
	}
	
	private void writeNodeDefinitionFile(String xml, String projectPath, IProject proj) throws Exception{
		Document doc = XMLDocumentUtility.loadXml(xml);
		ByteArrayOutputStream baos = XMLDocumentUtility.createByteArray(doc);
		byte[] buildContentArray = baos.toByteArray();
		IFile file = proj.getFile(projectPath);
		file.create(new ByteArrayInputStream(buildContentArray), true, null);
	}
	
}
