/*
 * Created on Nov 14, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.actionconfig;

import java.util.ArrayList;
import java.util.List;

/**
 * Class that maintains all the Configuration for an Action Class.
 * 
 * @author Vijay Silva
 */
public class ActionClassConfiguration {

	private String className;

	private List<ActionVariableConfiguration> variables = new ArrayList<ActionVariableConfiguration>();

	/**
	 * Constructor
	 * 
	 * @param className
	 *            The class name for the action class.
	 */
	public ActionClassConfiguration(String className) {
		this(className, null);
	}

	/**
	 * Constructor
	 * 
	 * @param className
	 *            The class name for the action class.
	 * @param variables
	 *            The list of ActionVariableConfiguration objects
	 */
	public ActionClassConfiguration(String className, List<ActionVariableConfiguration> variables) {
		this.className = className;
		this.setVariables(variables);
	}

	/**
	 * Get the Action Class Name
	 * 
	 * @return the className
	 */
	public String getClassName() {
		return this.className;
	}

	/**
	 * Get the Variables
	 * 
	 * @return the variables
	 */
	public List<ActionVariableConfiguration> getVariables() {
		return new ArrayList<ActionVariableConfiguration>(this.variables);
	}

	/**
	 * Set the Variables
	 * 
	 * @param variables
	 *            the variables to set
	 */
	protected void setVariables(List<ActionVariableConfiguration> variables) {
		this.variables.clear();

		if (variables != null)
			this.variables.addAll(variables);
	}
}
