/**
 * ActionBarContributor.java
 * Created Jun 18, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;

/**
 * Contributes the zoom action
 * 
 * @author Sahil Verma
 */
public class ActionBarContributor extends org.jbpm.gd.common.editor.ActionBarContributor {

	/**
	 * Adds a zoom level to the toolbar
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		super.contributeToToolBar(toolBarManager);
		
		toolBarManager.add(new Separator());
		toolBarManager.add(new ZoomComboContributionItem(getPage()));
	}
}
