/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.part.FileEditorInput;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * A file editor input with a watchpoint dto object.
 * 
 * @author Imran Naqvi
 *
 */
public class WPFileEditorInput extends FileEditorInput {

	IWatchPointDTO watchPointDTO;

	/**
	 * Constructor
	 * 
	 * @param file
	 *            The File containing the gpd
	 * @param watchPointDTO
	 *            The WatchPoint DTO
	 */
	public WPFileEditorInput(IFile file, IWatchPointDTO watchPointDTO) {
		super(file);
		this.watchPointDTO = watchPointDTO;
	}

	/**
	 * @return the watchPointDTO
	 */
	public IWatchPointDTO getWatchPointDTO() {
		return watchPointDTO;
	}

	/**
	 * @see org.eclipse.ui.part.FileEditorInput#hashCode()
	 */
	@Override
	public int hashCode() {
		if (this.watchPointDTO == null)
			return super.hashCode();

		return this.watchPointDTO.hashCode() * 7 - 456;
	}

	/**
	 * @see org.eclipse.ui.part.FileEditorInput#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof WPFileEditorInput))
			return false;

		WPFileEditorInput input = (WPFileEditorInput) obj;
		if (this.watchPointDTO != null)
			return watchPointDTO.equals(input.watchPointDTO);

		return super.equals(obj);
	}
}
