package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.common.figure.NodeContainerFigure;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.notation.NotationMapping;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * The purposoe of this class is to "inject" a new type of NodeHeaderFigure, by instantiating WatchPointNodeFigure, instead of NodeFigure, when necessary.
 * 
 * @author beroubach
 */
public class WPNodeFigureFactory {

    public static IFigure createFigure(NotationElement notationElement, ImageDescriptor transparentImageDescriptor) {
        if (notationElement instanceof NodeContainer) {
            return new NodeContainerFigure();
        }
        SemanticElement semanticElement = notationElement.getSemanticElement();
        String label = ((SemanticElement)semanticElement).getLabel();
        ImageDescriptor imageDescriptor = ((SemanticElement)semanticElement).getIconDescriptor();
        if (!(notationElement.getSemanticElement() instanceof NodeDefinition)) {
            transparentImageDescriptor = null;
        }

        if (imageDescriptor == null) return null;
        if (label != null) {
            return new WPNodeFigure(label, NotationMapping.hideName(semanticElement.getElementId()), imageDescriptor, transparentImageDescriptor);
        } else {
            return null;
        }
    }
}