/*
 * Created on Sep 21, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.ui.forms.AbstractFormPart;

/**
 * Modify Listener that makes the Section Part dirty if the text is modified in the control
 * 
 * @author Vijay Silva
 */
public class FormPartDirtyModifyListener implements ModifyListener
{
	AbstractFormPart formPart = null;

	/**
	 * @param part
	 *            The Section Part that will be marked dirty in case of modifications
	 */
	public FormPartDirtyModifyListener(AbstractFormPart part)
	{
		this.formPart = part;
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent event)
	{
		if (this.formPart != null && !this.formPart.isDirty())
			this.formPart.markDirty();
	}
}
