/*
 * Created on Sep 24, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.FormPartDirtyModifyListener;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.eventhandler.TextTrimFocusListener;

/**
 * The Section Part for the Default Adaptor Configuration
 * 
 * @author Vijay Silva
 */
public class DefaultAdaptorSectionPart extends ResourceTypeSectionPart
{
	Label messageIdentifierLabel, defaultMessageLabel;

	Text messageIdentifierText;

	// ========================================================================
	// ===================== CONSTRUCTORS
	// ========================================================================

	/**
	 * @param parentPart
	 *            The Part that contains this composite
	 * @param parent
	 *            The Parent Composite containing the section to be created
	 * @param toolkit
	 *            The toolkit to create the section with
	 * @param style
	 *            The style bits to create the section with
	 */
	public DefaultAdaptorSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit,
			int style)
	{
		super(parentPart, parent, toolkit, style);
	}

	// ========================================================================
	// ===================== OVERRIDDEN SECTION PART METHODS
	// ========================================================================

	/**
	 * @see org.eclipse.ui.forms.AbstractFormPart#commit(boolean)
	 */
	@Override
	public void commit(boolean onSave)
	{
		super.commit(onSave);

		/* Update the Resource Type with the data in the widgets */
		ResourceType resourceType = this.getResourceType();
		if (resourceType != null)
		{
			String className = this.messageIdentifierText.getText();
			resourceType.setMessageIdentificationClassName(className);
		}
	}

	// ========================================================================
	// ===================== USER CONTROL INITIALIZATION
	// ========================================================================

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart#createSectionClientControls(org.eclipse.ui.forms.IManagedForm)
	 */
	@Override
	protected void createSectionClientControls(IManagedForm managedForm)
	{
		FormToolkit toolkit = managedForm.getToolkit();

		/* The Message Identifier Class Label and Text */
		String labelName = "Message Identifier Class: ";
		this.messageIdentifierLabel = toolkit.createLabel(this.sectionClient, labelName);
		this.messageIdentifierText = toolkit.createText(this.sectionClient, "");
		this.messageIdentifierText.setTextLimit(256);
		this.messageIdentifierText.addFocusListener(new TextTrimFocusListener());
		this.messageIdentifierText.addModifyListener(new FormPartDirtyModifyListener(this));

		/* Create a Message Label */
		toolkit.createLabel(this.sectionClient, "");
		labelName = "* Leave blank in order to use default Message Identifier implementation.";
		this.defaultMessageLabel = toolkit.createLabel(this.sectionClient, labelName, SWT.WRAP);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart#initializeSectionClientLayout(org.eclipse.ui.forms.IManagedForm)
	 */
	@Override
	protected void initializeSectionClientLayout(IManagedForm managedForm)
	{
		/* Set the Layout for the Section Client in the Form */
		this.sectionClient.setLayout(this.createGridLayout(2, false));

		/* Set the default Layout data for the widgets */
		this.messageIdentifierLabel.setLayoutData(this.createLabelGridData());
		this.defaultMessageLabel.setLayoutData(this.createLabelGridData());

		GridData layoutData = this.createGridData();
		layoutData.widthHint = this.getDefaultClassNameTextWidth();
		this.messageIdentifierText.setLayoutData(layoutData);
	}

	// ========================================================================
	// ===================== DISPLAYING THE INPUT DATA
	// ========================================================================

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart#populateSectionData()
	 */
	@Override
	protected void populateSectionData()
	{
		ResourceType resourceType = this.getResourceType();

		if (resourceType != null)
		{
			String className = resourceType.getMessageIdentificationClassName();
			this.messageIdentifierText.setText(this.formatValue(className, true));
		}
		else
		{
			this.messageIdentifierText.setText("");
		}
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.ResourceTypeSectionPart#setWidgetPermissions()
	 */
	@Override
	protected void setWidgetPermissions()
	{
		boolean isEditable = this.isInputEditable();
		this.messageIdentifierText.setEditable(isEditable);
	}
}
