/*
 * Created on Oct 1, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import org.eclipse.core.runtime.IAdaptable;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;

/**
 * Input set in the Message Section Part to display an existing message
 * 
 * @author Vijay Silva
 */
public class MessageInput implements IEditableElement, IAdaptable
{
	private Message message;
	private String timeout;

	private boolean isEditable = true;

	public void setTimeout(String timeout) {
		this.timeout = timeout;
	}

	public String getTimeout() {
		return timeout;
	}

	/**
	 * Constructor. The Message is editable by default.
	 * 
	 * @param message
	 *            The Message
	 */
	public MessageInput(Message message)
	{
		this(message, true);
	}

	/**
	 * Constructor.
	 * 
	 * @param message
	 *            The Message
	 * @param isEditable
	 *            Flag to indicate if the message can be edited or not
	 */
	public MessageInput(Message message, boolean isEditable)
	{
		this.message = message;
		this.isEditable = isEditable;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IEditableElement#canEdit()
	 */
	public boolean canEdit()
	{
		return this.isEditable;
	}

	/**
	 * @return The message
	 */
	public Message getMessage()
	{
		return this.message;
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@SuppressWarnings("rawtypes")
	public Object getAdapter(Class adapterClass)
	{
		Object adapter = null;

		if (adapterClass.isInstance(this.message))
		{
			adapter = this.message;
		}
		else if (adapterClass.isInstance(this))
		{
			return this;
		}

		return adapter;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.message == null)
			return super.hashCode();

		int hashCode = 5 * this.message.hashCode() - 31;
		return hashCode;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof MessageInput))
			return false;

		MessageInput input = (MessageInput) obj;
		if (this.message != null)
			return this.message.equals(input.message);

		return super.equals(obj);
	}
}
